
cp_95771(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/11/2010 */
parameter real bailout,mandalabailout;
parameter quaternion perturb;
parameter quaternion c;
real sx,sx2,sy,sy2,sz,sz2,sw,sv,su;
real nx,ny,nz,nw,nv,nu;
real r,r1,r2,r3,r1b,r2b,r3b,a,b,bail;
parameter int fractaltype;
parameter int assignment;
real cr,ci,cj,ck,cw,cv,cu,i;
real theta,phi,tango,whiskey,foxtrot;
real pixelr,pixeli,pixelj,pixelw,pixelv,pixelu;
parameter real n,mag,mag2,v,bail1,bail2,lt,pt;
parameter bool bailcontrol,juliaMode,sumode;

	void init(void)
	{
		
		if (fractaltype=="Mandala" || fractaltype== "Mandala 2") {
		bailout=mandalabailout;
		}
		
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		
		pixelr=part_r(pixel);
		pixeli=part_i(pixel);
		pixelj=part_j(pixel);

		/* Assigning different values to the planar variables can result in interesting
		   images, so I decided to include the ability to do so in this version of the code.
			Additional variety can be implemented by further varying the method of planar 
			assignment, although a large amount of the various possibilities of sign +/-
			assignment are "mixed and matched" in the various linear/planar sign assignment
			schemes */
		
	
		
		if (assignment=="Magnitude") {
			pixelw=sqrt(pixeli^2+pixelj^2);
			pixelv=sqrt(pixelr^2+pixelj^2);
			pixelu=sqrt(pixelr^2+pixeli^2);
			cw=sqrt(ci^2+cj^2);
			cv=sqrt(cr^2+cj^2);
			cu=sqrt(cr^2+ci^2);
		} else if (assignment=="-Magnitude") {
			pixelw=0-sqrt(pixeli^2+pixelj^2);
			pixelv=0-sqrt(pixelr^2+pixelj^2);
			pixelu=0-sqrt(pixelr^2+pixeli^2);
			cw=0-sqrt(ci^2+cj^2);
			cv=0-sqrt(cr^2+cj^2);
			cu=0-sqrt(cr^2+ci^2);
		} else if (assignment=="Linear Sign Magnitude") {
			if (pixelr<0) {
			pixelw=0-sqrt(pixeli^2+pixelj^2);
			} else {
			pixelw=sqrt(pixeli^2+pixelj^2);
			}
			if (pixeli<0) {
			pixelv=0-sqrt(pixelr^2+pixelj^2);
			} else {
			pixelv=sqrt(pixelr^2+pixelj^2);
			}
			if (pixelj<0) {
			
			pixelu=0-sqrt(pixelr^2+pixeli^2);
			} else {
			pixelu=sqrt(pixelr^2+pixeli^2);
			}
			/*  c variable assignments in each one as well */
			if (cr<0) {
			cw=0-sqrt(ci^2+cj^2);
			} else {
			cw=sqrt(ci^2+cj^2);
			}
			if (ci<0) {
			cv=0-sqrt(cr^2+cj^2);
			} else {
			cv=sqrt(cr^2+cj^2);
			}
			if (cj<0) {
			
			cu=0-sqrt(cr^2+ci^2);
			} else {
			cu=sqrt(cr^2+ci^2);
			}
		} else {   /* these variables will be used in all the next assignments  */
			pixelw=pixeli*abs(pixeli)+abs(pixelj)*pixelj;
			pixelv=pixelr*abs(pixelr)+abs(pixelj)*pixelj;
			pixelu=pixelr*abs(pixelr)+abs(pixeli)*pixeli;
			cw=ci*abs(ci)+abs(cj)*cj;
			cv=cr*abs(cr)+abs(cj)*cj;
			cu=cr*abs(cr)+abs(ci)*ci;
		
			if (assignment=="Planar Sign Magnitude") {
			
				if (pixelw<0) {
					pixelw=0-sqrt(pixeli^2+pixelj^2);
					} else {
					pixelw=sqrt(pixeli^2+pixelj^2);
					}
				if (pixelv<0) {
					pixelv=0-sqrt(pixelr^2+pixelj^2);
					} else {
					pixelv=sqrt(pixelr^2+pixelj^2);
					}
				if (pixelu<0) {
					pixelu=0-sqrt(pixelr^2+pixeli^2);
					} else {
					pixelu=sqrt(pixelr^2+pixeli^2);
					}
				if (cw<0) {
					cw=0-sqrt(ci^2+cj^2);
					} else {
					cw=sqrt(ci^2+cj^2);
					}
				if (cv<0) {
					cv=0-sqrt(cr^2+cj^2);
					} else {
					cv=sqrt(cr^2+cj^2);
					}
				if (cu<0) {
					cu=0-sqrt(cr^2+ci^2);
					} else {
					cu=sqrt(cr^2+ci^2);
					}	
					
					
			} else if (assignment=="Complexitude") {
				pixelw=sqrt(abs(pixelw));
				pixelv=sqrt(abs(pixelv));
				pixelu=sqrt(abs(pixelu));
				cw=sqrt(abs(cw));
				cv=sqrt(abs(cv));
				cu=sqrt(abs(cu));
			} else if (assignment=="-Complexitude") {
				pixelw=0-sqrt(abs(pixelw));
				pixelv=0-sqrt(abs(pixelv));
				pixelu=0-sqrt(abs(pixelu));
				cw=0-sqrt(abs(cw));
				cv=0-sqrt(abs(cv));
				cu=0-sqrt(abs(cu));
			} else if (assignment=="Linear Sign Complexitude") {
				if (pixelr<0) {
					pixelw=0-sqrt(abs(pixelw));
					} else {
					pixelw=sqrt(abs(pixelw));
					}
				if (pixeli<0) {
					pixelv=0-sqrt(abs(pixelv));
					} else {
					pixelv=sqrt(abs(pixelv));
					}
				if (pixelj<0) {
					pixelu=0-sqrt(abs(pixelu));
					} else {
					pixelu=sqrt(abs(pixelu));
					}
					
				if (cr<0) {
					cw=0-sqrt(abs(cw));
					} else {
					cw=sqrt(abs(cw));
					}
				if (ci<0) {
					cv=0-sqrt(abs(cv));
					} else {
					cv=sqrt(abs(cv));
					}
				if (cj<0) {
					cu=0-sqrt(abs(cu));
					} else {
					cu=sqrt(abs(cu));
					}
			} else if (assignment=="Planar Sign Complexitude") {
				if (pixelw<0) {
					pixelw=0-sqrt(abs(pixelw));
					} else {
					pixelw=sqrt(abs(pixelw));
					}
				if (pixelv<0) {
					pixelv=0-sqrt(abs(pixelv));
					} else {
					pixelv=sqrt(abs(pixelv));
					}
				if (pixelu<0) {
					pixelu=0-sqrt(abs(pixelu));
					} else {
					pixelu=sqrt(abs(pixelu));
					}
					
				if (cw<0) {
					cw=0-sqrt(abs(cw));
					} else {
					cw=sqrt(abs(cw));
					}
				if (cv<0) {
					cv=0-sqrt(abs(cv));
					} else {
					cv=sqrt(abs(cv));
					}
				if (cu<0) {
					cu=0-sqrt(abs(cu));
					} else {
					cu=sqrt(abs(cu));
					}
			}	
		}
		
		if (juliaMode) {
			sx=pixelr;
			sy=pixeli;
			sz=pixelj;
			sw=pixelw;
			sv=pixelv;
			su=pixelu;
			
		} else {
			sx=cr;
			sy=ci;
			sz=cj;
			sw=cw;
			sv=cv;
			su=cu;
		}
		 if (fractaltype=="Type B2" ||"Type B1" || "Type B3" || "Type C1" || "Type C2") {
			sx2=sx;
			sy2=sy;
			sz2=sz;
			}
	}
	void loop(void)
	{
		if (fractaltype=="Type R2 D2") {
			
				r2= sqrt((sx^2+sy^2+sz^2)^n+(sw^2+sv^2+su^2)^mag2);
			
				 if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				 nx=r2*sin(v*phi) ;
				 ny=r2*sin(v*tango);
				 nz=r2*sin(v*theta);
				 nw=r2*cos(mag*phi) ;
				 nv=r2*cos(mag*tango) ;
				 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
		} if (fractaltype=="Mandala 2") {
				r1=(sx^2+sy^2+sz^2)^(n/2);
				r2= (sw^2+sv^2+su^2)^(mag2/2);
			
				 if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				 nx=r1*sin(v*phi) ;
				 ny=r1*sin(v*tango);
				 nz=r1*sin(v*theta);
				 nw=r2*cos(mag*phi) ;
				 nv=r2*cos(mag*tango) ;
				 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
		} else if (fractaltype=="R2 D2 intraplanar") {
					
					phi=atan2(sx+flip(sy));  /*su*/
					tango=atan2(sy+flip(sz));  /*sw*/
					theta=atan2(sx+flip(sz));     /*sv*/
					
				 sy2=sw*cos(v*tango);
				 sz2=sw*sin(v*tango);
				 sw=sqrt(sy2^2+sz2^2);
				 
				 sx2=su*cos(v*phi);
				 sy2=su*sin(v*phi);
				 su=sqrt(sx2^2+sy2^2);
				 
				 sx2=sv*cos(v*theta);
				 sz2=sv*sin(v*theta);
				 sv=sqrt(sx2^2+sz2^2);
				
				r2= sqrt((sx^2+sy^2+sz^2)^n+(sw^2+sv^2+su^2)^mag2);
			
				 if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
					
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				 nx=r2*sin(v*phi) ;
				 ny=r2*sin(v*tango);
				 nz=r2*sin(v*theta);
				 
				 
				 nw=r2*cos(mag*phi) ;
				 nv=r2*cos(mag*tango) ;
				 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
		} else if (fractaltype=="Type R3 D2") {
			
				r2= sqrt(0-(sx^2+sy^2+sz^2)^n+(sw^2+sv^2+su^2)^mag2);
			
				 if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				 nx=r2*sin(v*phi) ;
				 ny=r2*sin(v*tango);
				 nz=r2*sin(v*theta);
				 nw=r2*cos(mag*phi) ;
				 nv=r2*cos(mag*tango) ;
				 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
		} else if (fractaltype=="Type D2") {
				if (n==mag2) {	
				r1= ((sx^2+sy^2+sz^2+sw^2+sv^2+su^2))^(n/2);
				r2=r1;
				} else {
				r=(sx^2+sy^2+sz^2+sw^2+sv^2+su^2);
				r1=r^(n/2);
				r2=r^(mag2/2);
				}
				 if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				 nx=r1*sin(v*phi) ;
				 ny=r1*sin(v*tango);
				 nz=r1*sin(v*theta);
				 nw=r2*cos(mag*phi) ;
				 nv=r2*cos(mag*tango) ;
				 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
		} else if (fractaltype=="Type D2/D3 Hybrid") {
			 	if (n==mag2) {	
				r1= (sx^2+sw^2)^(n/2)+(sy^2+sv^2)^(n/2)+(sz^2+su^2)^(n/2) ;
				r2=r1;
				} else {
				r1=(sx^2+sw^2)^(n/2)+(sy^2+sv^2)^(n/2)+(sz^2+su^2)^(n/2) ;
				r2=(sx^2+sw^2)^(mag2/2)+(sy^2+sv^2)^(mag2/2)+(sz^2+su^2)^(mag2/2) ;
				}
	 		 
			  if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				
			 nx=r1*sin(v*phi) ;
			 ny=r1*sin(v*tango);
			 nz=r1*sin(v*theta);
			 nw=r2*cos(mag*phi) ;
			 nv=r2*cos(mag*tango) ;
			 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
				
				if (bailcontrol) {	
				bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
				}
		} else if (fractaltype=="Type D3") {
			if (n==mag2) {
				r1=(sx^2+sw^2)^(n/2);
				r2=(sy^2+sv^2)^(n/2);
				r3=(sz^2+su^2)^(n/2);
				r1b=r1;
				r2b=r2;
				r3b=r3;
			} else {
				r1=(sx^2+sw^2)^(n/2);
				r2=(sy^2+sv^2)^(n/2);
				r3=(sz^2+su^2)^(n/2);
				r1b=(sx^2+sw^2)^(mag2/2);
				r2b=(sy^2+sv^2)^(mag2/2);
				r3b=(sz^2+su^2)^(mag2/2);
			}	
			
			 if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				
			nx=r1*sin(v*phi) ;
			ny=r2*sin(v*tango);
			nz=r3*sin(v*theta);
			nw=r1b*cos(mag*phi) ;
			nv=r2b*cos(mag*tango) ;
			nu=r3b*cos(mag*theta)  ;
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
			}
			if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
		}
		} else if (fractaltype=="Mandala") {
			 if (n==mag2) {
				r1=(sx^2+sy^2+sz^2)^(n/2);
				r2=r1;
			} else {
				r1=(sx^2+sy^2+sz^2)^(n/2);
				r2=(sx^2+sy^2+sz^2)^(mag2/2);
			}
			  if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				
			 nx=r1*sin(v*phi) ;
			 ny=r1*sin(v*tango);
			 nz=r1*sin(v*theta);
			 nw=r2*cos(mag*phi) ;
			 nv=r2*cos(mag*tango) ;
			 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
				
				if (bailcontrol) {	
				bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
				}
			
		} else if (fractaltype=="Spiky D2") {
			 if (n==mag2) {
				r1=(sw^2+sv^2+su^2)^(n/2);
				r2=r1;
			} else {
				r1=(sw^2+sv^2+su^2)^(n/2);
				r2=(sw^2+sv^2+su^2)^(mag2/2);
			}
			  if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
				
			 nx=r1*sin(v*phi) ;
			 ny=r1*sin(v*tango);
			 nz=r1*sin(v*theta);
			 nw=r2*cos(mag*phi) ;
			 nv=r2*cos(mag*tango) ;
			 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
				
				if (bailcontrol) {	
				bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
				}
			
		} else if (fractaltype=="D2 Bulb Hybrid") {	 	  
			    if (n==mag2) {
					r1= ((sx^2+sy^2+sz^2+sw^2+sv^2+su^2))^(n/2);
					r2=r1;
				} else {
					r1= ((sx^2+sy^2+sz^2+sw^2+sv^2+su^2))^(n/2);
					r2=((sx^2+sy^2+sz^2+sw^2+sv^2+su^2))^(mag2/2);
				}
				 if(pt==1&&lt==1) {
					phi=atan2(sw+flip(sx));
					tango=atan2(sv+flip (sy));
					theta=atan2(su+flip(sz));
				} else {
					phi=atan2(sw^pt+flip(sx^lt));
					tango=atan2(sv^pt+flip (sy^lt));
					theta=atan2(su^pt+flip(sz^lt));
				}	
					
				 nx=r1*sin(v*phi) ;
				 ny=r1*sin(v*tango);
				 nz=r1*sin(v*theta);
				 nw=r2*cos(mag*phi) ;
				 nv=r2*cos(mag*tango) ;
				 nu=r2*cos(mag*theta)  ;
					
				
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			
			
			/* bulb part  */
			if (n==mag2) {
				r1=(sx^2+sy^2+sz^2)^(n/2);
				r2=(sw^2+sv^2+su^2)^(n/2);
				r1b=r1;
				r2b=r2;
			
			} else {
				r1=(sx^2+sy^2+sz^2)^(n/2);
				r2=(sw^2+sv^2+su^2)^(n/2);
				r1b=(sx^2+sy^2+sz^2)^(mag2/2);
				r2b=(sw^2+sv^2+su^2)^(mag2/2);
			
			}
		     if (pt==1&&lt==1) {
				theta=atan2(sqrt(sx^2+sy^2)+flip(sz));
				phi=atan2(sx+flip(sy));
				tango=atan2(sqrt(sw^2+sv^2)+flip(su));
				whiskey=atan2(sw+flip(sv));
			} else {
				 theta=atan2((sx^2+sy^2)^(lt/2)+flip(sz^lt));
				phi=atan2(sx^lt+flip(sy^lt));
				tango=atan2((sw^2+sv^2)^(pt/2)+flip(su^pt));
				whiskey=atan2(sw^pt+flip(sv^pt));
			}
			 nx=r1*cos(theta*v)*cos(phi*v);
			 ny=r1*cos(theta*v)*sin(phi*v);
			 nz=r1b*sin(theta*v);
			 nw=r2*cos(tango*mag)*cos(whiskey*mag);
			 nv=r2*cos(tango*mag)*sin(whiskey*mag);
			 nv=r2b*sin(tango*mag);
			 
			 	
				if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				sw=nw+cw;
				sv=nv+cv;
				su=nu+cu;
				} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				sw=nw+pixelw;
				sv=nv+pixelv;
				su=nu+pixelu;
				}
			
			 
			 
			 if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
			
		} else if (fractaltype=="Mandelbulb B") {
			if (n==mag2) {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=r1;
			} else {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=(sx^2+sy^2+sz^2)^(mag2/2);
			}
			
			theta=atan2(su^pt+flip(sz^lt));
			phi=atan2(sy^lt+flip(sx^lt));
			
			nx=r1*sin(v*phi)*cos(mag*theta);
			ny=r1*cos(v*phi)*cos(mag*theta);
			nz=r1*sin(mag*theta);
			nu=r2*cos(mag*theta);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				su=nu+cu;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				su=nu+pixelu;
				}
		
			
			 if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
		} else if (fractaltype=="Mandelbulb B2") {
			if (n==mag2) {
			r1=(sx^2+sy^2+sz^2+su^2)^(n/2);
			r2=r1;
			} else {
			r1=(sx^2+sy^2+sz^2+su^2)^(n/2);
			r2=(sx^2+sy^2+sz^2+su^2)^(mag2/2);
			}
			theta=atan2(su^pt+flip(sz^lt));
			phi=atan2(sy^lt+flip(sx^lt));
			
			nx=r1*sin(v*phi)*cos(mag*theta);
			ny=r1*cos(v*phi)*cos(mag*theta);
			nz=r1*sin(mag*theta);
			nu=r2*cos(mag*theta);
			
			if (juliaMode) {
				sx=nx+cr;
				sy=ny+ci;
				sz=nz+cj;
				su=nu+cu;
			} else {
				sx=nx+pixelr;
				sy=ny+pixeli;
				sz=nz+pixelj;
				su=nu+pixelu;
				}
			
			
			 if (bailcontrol) {	
			bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
			} else {
			bail=abs(sx)+abs(sy)+abs(sz);
			}
			
		} else if (fractaltype=="Type B1") {
		     if (n==mag2) {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=r1;
			} else {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=(sx^2+sy^2+sz^2)^(mag2/2);
			}
			theta=atan2(sx^pt+flip(sy^lt));
			tango=atan2(sx2^pt+flip(sz^lt)); 
			
			 if (juliaMode) {
			  sx=r2*cos(theta*mag)+cr;
		      sx2=r2*cos(tango*mag)+cr;
		 
		      sy=r1*sin(theta*v)+ci;
		      sz=r1*sin(tango*v)+cj;
			} else {
		      sx=r2*cos(theta*mag)+pixelr;
		      sx2=r2*cos(tango*mag)+pixelr;
		 
		      sy=r1*sin(theta*v)+pixeli;
		      sz=r1*sin(tango*v)+pixelj;
			}
		      sx=sqrt(abs(sx*sx2));  /* NORMAL MODE */
			 sx2=sx;
			 if (bailcontrol) {	
					bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
			  }
		} else if (fractaltype=="Type B2") {
			if (n==mag2) {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=r1;
			} else {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=(sx^2+sy^2+sz^2)^(mag2/2);
			}
			theta=atan2(sx^pt+flip(sy^lt));
			tango=atan2(sx2^pt+flip(sz^lt)); 
			
			if (juliaMode) {
			  sx=r2*cos(theta*mag)+cr;
		      sx2=r2*cos(tango*mag)+cr;
		 
		      sy=r1*sin(theta*v)+ci;
		      sz=r1*sin(tango*v)+cj;
			} else {
		      sx=r2*cos(theta*mag)+pixelr;
		      sx2=r2*cos(tango*mag)+pixelr;
		 
		      sy=r1*sin(theta*v)+pixeli;
		      sz=r1*sin(tango*v)+pixelj;
			}
		      sx=sqrt(sqr(sx)+sqr(sx2));  
			 sx2=sx;
			 if (bailcontrol) {	
					bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
			  }
		} else if (fractaltype=="Type B3") {
			if (n==mag2) {
				r1=(sx^2+sy^2+sz^2)^(n/2);
				r2=r1;
			} else {
				r1=(sx^2+sy^2+sz^2)^(n/2);
				r2=(sx^2+sy^2+sz^2)^(mag2/2);
			}
		  theta=atan2(sx^lt+flip(sy^lt));
		  tango=atan2(sx^lt+flip(sz^lt));
		  whiskey=atan2(sx^lt+flip(sw^pt));
		  
		  if (juliaMode) {
			sx=r1*cos(whiskey*v)+cr;
			sy=r1*sin(theta*v)+ci;
			sz=r1*sin(tango*v)+cj;
			sw=r2*sin(whiskey*mag)+cw;
		 } else {
			sx=r1*cos(whiskey*v)+pixelr;
			sy=r1*sin(theta*v)+pixeli;
			sz=r1*sin(tango*v)+pixelj;
			sw=r2*sin(whiskey*mag)+pixelw;
		}
		
			 if (bailcontrol) {	
					bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
			  }
		} else if (fractaltype=="Type C1") {
		 if (n==mag2) {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=r1;
			} else {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=(sx^2+sy^2+sz^2)^(mag2/2);
			}
		  theta=atan2(sx^lt+flip(sy^lt));
		  tango=atan2(sx2^pt+flip(sz^lt));
		  whiskey=atan2(sy2^pt+flip(sz2^pt));
		  
			if (juliaMode) {
			sx=r1*cos(theta*v)+cr;
			sx2=r2*cos(tango*mag)+cr;
			sy=r1*sin(theta*v)+ci;
			sy2=r2*cos(whiskey*mag)+ci;
			sz=r1*sin(tango*v)+cj;
			sz2=r2*sin(whiskey*mag)+cj;
			} else {
			sx=r1*cos(theta*v)+pixelr;
			sx2=r2*cos(tango*mag)+pixelr;
			sy=r1*sin(theta*v)+pixeli;
			sy2=r2*cos(whiskey*mag)+pixeli;
			sz=r1*sin(tango*v)+pixelj;
			sz2=r2*sin(whiskey*mag)+pixelj;
			}
	
			sx=sqrt(abs(sx*sx2));
			sy=sqrt(abs(sy*sy2));
			sz=sqrt(abs(sz*sz2));
		
			sx2=sx;
			sy2=sy;
			sz2=sz;
		
			 if (bailcontrol) {	
					bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
			  }
		} else if (fractaltype=="Type C2") {
		  if (n==mag2) {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=r1;
			} else {
			r1=(sx^2+sy^2+sz^2)^(n/2);
			r2=(sx^2+sy^2+sz^2)^(mag2/2);
			}
		  theta=atan2(sx^lt+flip(sy^lt));
		  tango=atan2(sx2^pt+flip(sz^lt));
		  whiskey=atan2(sy2^pt+flip(sz2^pt));
		  
		  if (juliaMode) {
		  sx=r1*cos(theta*v)+cr;
		  sx2=r2*cos(tango*mag)+cr;
		  sy=r1*sin(theta*v)+ci;
		  sy2=r2*cos(whiskey*mag)+ci;
		  sz=r1*sin(tango*v)+cj;
		  sz2=r2*sin(whiskey*mag)+cj;
		  } else {
		  sx=r1*cos(theta*v)+pixelr;
		  sx2=r2*cos(tango*mag)+pixelr;
		  sy=r1*sin(theta*v)+pixeli;
		  sy2=r2*cos(whiskey*mag)+pixeli;
		  sz=r1*sin(tango*v)+pixelj;
		  sz2=r2*sin(whiskey*mag)+pixelj;
			}
		 sx=sqrt(sqr(sx)+sqr(sx2));
		 sy=sqrt(sqr(sy)+sqr(sy2));
		 sz=sqrt(sqr(sz)+sqr(sz2));
		

			
		  sx2=sx;
		  sy2=sy;
		  sz2=sz;
			
			 if (bailcontrol) {	
					bail=abs(sw)^bail1*abs(sx)^bail2+abs(sv)^bail1*abs(sy)^bail2+abs(su)^bail1*abs(sz)^bail2;
				} else {
				bail=abs(sx)+abs(sy)+abs(sz);
			  }
		}
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="Benesi Set";
		bailout.caption = "Bailout Value";
		bailout.default = 10^30;
		bailout.min = 1.0;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		
		fractaltype.caption="Formula";
		fractaltype.enum="Type R2 D2\nType D2\nType D3\nMandala 2\nMandala\nType B1\nMandelbulb B2\nR2 D2 intraplanar\nSpiky D2\nType R3 D2\nType D2/D3 Hybrid\nD2 Bulb Hybrid\nMandelbulb B\nType B2\nType B3\nType C1\nType C2";
		fractaltype.default=0;
		fractaltype.hint="If you select Mandala, MAKE SURE TO ROTATE THE FRACTAL EITHER HORIZONTALLY OR VERTICALLY BY 45 DEGREES";
			
		assignment.caption="P.V.A. Mode";
		assignment.enum="Magnitude\n-Magnitude\nLinear Sign Magnitude\nPlanar Sign Magnitude\nComplexitude\n-Complexitude\nLinear Sign Complexitude\nPlanar Sign Complexitude";
		assignment.default=0;
		assignment.hint="Planar variable assignment moded lets you specify how planar variables w, v, and u are assigned.  Leave on magnitude or -magnitude mode for most calculations, play around with complexitude modes for more complicated, albeit somewhat mismatched images";
		
		bailcontrol.caption="Bail control mode";
		bailcontrol.default=false;
		bailcontrol.hint="Use if you want to set bail exponents for planar and linear components of bailout.";
	
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		
		v.caption="Linear rotations";
		v.default=2;
		v.hint="You should set linear and planar magnitudes the same and linear and planar rotations the same as the magnitudes except you may alter signs (magnitudes should stay positive, but rotations can be negatives, like -2 linear and -2 planar rotation), until you become familiar with the effects.  Setting them differently in the Mandala formula, along with setting a negative and positive bail component, can result in awesome images.  ";
		n.caption="Linear magnitude";
		n.default=2;
		n.hint="See linear rotation hint.";
		mag.caption="Planar rotations";
		mag.default=2;
		mag.hint="See linear rotation hint.";
		mag2.caption="Planar Magnitude";
		mag2.default=2;
		mag2.hint="See linear rotation hint.";
		
		c.caption="c";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		
		bail1.caption="planar bail exponent";
		bail1.default=0;
		bail1.hint="for control of planar values exponent in bail control mode, use with Mandalamode for some awesome fractals";
		bail2.caption="linear bail exponent";
		bail2.default=1;
		bail2.hint="See bail exponent wvu hint as well, if you set one of these to a negative value 1 less than the other, cool stuff can happen in mandalamode";

		mandalabailout.caption="Mandala Bailout Value";
		mandalabailout.default=4;
		mandalabailout.hint="Set this higher AFTER you rotate your Mandala if you want a smoother Mandala";
	     lt.caption="Linear Trig Exponent";
		lt.default=1;
		lt.hint="Set to different values to change how angles are calculated.  Can result in interesting images in the Mandala formula, when combined with changing PVA mode.";
		pt.caption="Planar Trig Exponent";
		pt.default=1;
		pt.hint="See Linear Trig Hint";
		
		}
}

